/*==============================================================================
 Labor market series for Finland 
*=============================================================================*/
clear all
set more off

cd "$insheet_files/Finland/"

*===============================================================================
* I. Population	
*===============================================================================

import excel using "FI_yearbook_data.xls",first sheet("POP") clear

reshape long POP_, i(nuts region_name) j(year)

collapse (sum) POP, by(nuts year)

tempfile FI_pop
save `FI_pop.dta'

forvalues year=1970(1)2009 {
	capture {
		import excel using "FI_yearbook_data.xls",first sheet("`year'") clear
		
		collapse (sum) UNEMP EMP LF, by(nuts)
		
		gen year=`year'
		
		tempfile FI_labor_`year'
		save `FI_labor_`year''
	}	
}
	
forvalues year=1970(1)2009 {
	capture append using `FI_labor_`year'.dta'
}

duplicates drop 
merge 1:1 nuts year using `FI_pop.dta', nogen

label var LF "Labor force, Finland, Labor force survey"
label var EMP "Employed, Finland, Labor force survey"
label var UNEMP "Unemployed, Finland, Labor force survey"
	
rename LF LF_fi
rename EMP EMP_fi
rename UNEMP UNEMP_fi

sort nuts year
save "$dta_files/FI_labor", replace
